﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace NetBroadcaster
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        [DllImport("kernel32.dll")]
        public static extern uint GetProfileInt(string lpAppName, string lpKeyName, int nDefault);

        [DllImport("kernel32.dll")]
        public static extern bool WriteProfileString(string lpAppName, string lpKeyName, string lpString);

        public uint i = 0;

        public uint m_nPort_RTSPOverHTTP = 0;

        public uint m_nPort_RTSP = 0;

        public uint m_pDevice = 0x00000000;

        public uint m_hNetworkServer = 0x00000000;

        volatile public uint m_nNetworkServerState = 0x00000000;

        public uint m_nVideoWidth = 0;

        public uint m_nVideoHeight = 0;

        public bool m_bVideoIsInterleaved = false;

        public double m_dVideoFrameRate = 0.0;

        public uint m_nAudioChannels = 0;

        public uint m_nAudioBitsPerSample = 0;

        public uint m_nAudioSampleFrequency = 0;

        string m_psz;

        // CRITICAL SECTION OBJECT
        // 
        private Object m_hNetworkServerAccessCriticalSection = new Object();

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            m_nVideoWidth = 0;

            m_nVideoHeight = 0;

            m_bVideoIsInterleaved = false;

            m_dVideoFrameRate = 0.0;

            m_nAudioChannels = 0;

            m_nAudioBitsPerSample = 0;

            m_nAudioSampleFrequency = 0;

            m_psz = "INFO: ...";            

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            m_nVideoWidth = 0;

            m_nVideoHeight = 0;

            m_bVideoIsInterleaved = false;

            m_dVideoFrameRate = 0.0;

            m_nAudioChannels = 0;

            m_nAudioBitsPerSample = 0;

            m_nAudioSampleFrequency = 0;

            m_psz = "INFO: ...";            

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            m_nVideoWidth = nVideoWidth;

            m_nVideoHeight = nVideoHeight;

            if (bVideoIsInterleaved == 0) { m_bVideoIsInterleaved = false; }

            if (bVideoIsInterleaved == 1) { m_bVideoIsInterleaved = true; }            

            m_dVideoFrameRate = dVideoFrameRate;

            m_nAudioChannels = nAudioChannels;

            m_nAudioBitsPerSample = nAudioBitsPerSample;

            m_nAudioSampleFrequency = nAudioSampleFrequency;            

            if (bVideoIsInterleaved == 1)
            {
                m_psz = @"INFO: " + nVideoWidth.ToString() + " x " + nVideoHeight.ToString() + "I@" + dVideoFrameRate.ToString() + "FPS, " + nAudioChannels.ToString() + " x " + nAudioBitsPerSample.ToString() + "BITSx" + nAudioSampleFrequency.ToString() + "HZ";                
            }
            else
            {
                m_psz = @"INFO: " + nVideoWidth.ToString() + " x " + nVideoHeight.ToString() + "P@" + dVideoFrameRate.ToString() + "FPS, " + nAudioChannels.ToString() + " x " + nAudioBitsPerSample.ToString() + "BITSx" + nAudioSampleFrequency.ToString() + "HZ";                
            }
          
            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            // ENTER CRITICAL SECTION
            //
            lock (m_hNetworkServerAccessCriticalSection)
            {
                if (m_nNetworkServerState > 0x00000000)
                {
                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hNetworkServer, 0, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);

                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hNetworkServer, 1, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                }
            }
            //
            // LEAVE CRITICAL SECTION            

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            // ENTER CRITICAL SECTION
            //
            lock (m_hNetworkServerAccessCriticalSection)
            {
                if (m_nNetworkServerState > 0x00000000)
                {
                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen);

                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen);
                }
            }
            //
            // LEAVE CRITICAL SECTION

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            m_nPort_RTSP = GetProfileInt("DEFAULT", "PORT.RTSP", 554);

            m_nPort_RTSPOverHTTP = GetProfileInt("DEFAULT", "PORT.HTTP", 8080);

            m_scPort_RTSP.Text = m_nPort_RTSP.ToString();

            m_scPort_RTSPOverHTTP.Text = m_nPort_RTSPOverHTTP.ToString();

            HwInitialize();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            btnStop_Click(sender, e);

            HwUnInitialize();           

            WriteProfileString("DEFAULT", "PORT.RTSP", m_scPort_RTSP.Text);

            WriteProfileString("DEFAULT", "PORT.HTTP", m_scPort_RTSPOverHTTP.Text);
        }

        public bool HwInitialize()
        {
            // INITIALIZE DEVICE RESOURCE
            //            

            string strChipName = "SA7160 PCI";

            EXPORTS.QCAP_CREATE(ref strChipName, 0, (uint)m_statDisplayWindow.Handle.ToInt32(), ref m_pDevice, 1);

            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_pDevice, m_pFormatChangedCB, 0);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_pDevice, m_pPreviewVideoCB, 0);

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_pDevice, m_pPreviewAudioCB, 0);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_pDevice, m_pNoSignalDetectedCB, 0);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_pDevice, m_pSignalRemovedCB, 0);

            // SET INPUT
            //
            EXPORTS.QCAP_SET_VIDEO_INPUT(m_pDevice, (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO);

            EXPORTS.QCAP_SET_AUDIO_INPUT(m_pDevice, (uint)EXPORTS.InputAudioSourceEnum.QCAP_INPUT_TYPE_EMBEDDED_AUDIO);

            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_pDevice, 0);

            EXPORTS.QCAP_RUN(m_pDevice);

            return true;
        }

        public bool HwUnInitialize()
        {
            // UNINITIALIZE DEVICE RESOURCE
            //
            if (m_pDevice != 0) { EXPORTS.QCAP_STOP(m_pDevice); EXPORTS.QCAP_DESTROY(m_pDevice); }

            return true;
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            btnStop_Click(sender, e);

            if (m_nVideoWidth == 0) { return; }

            if (m_nVideoHeight == 0) { return; }

            String strAccount = "root";

            String strPassword = "root";

            m_nPort_RTSP = Convert.ToUInt32(m_scPort_RTSP.Text);

            m_nPort_RTSPOverHTTP = Convert.ToUInt32(m_scPort_RTSPOverHTTP.Text);

            EXPORTS.QCAP_CREATE_BROADCAST_RTSP_SERVER(0, 2 /*2 CHANNELS*/, ref m_hNetworkServer, ref strAccount, ref strPassword, m_nPort_RTSP, m_nPort_RTSPOverHTTP);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, 1280, 720, 30, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, 0, 0, 0, (uint)EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_FULL);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, 640, 360, 30, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 2000000, 30, 0, 0, 0, 0, 0, (uint)EXPORTS.BroadCastFlagEnum.QCAP_BROADCAST_FLAG_FULL);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hNetworkServer, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

            EXPORTS.QCAP_START_BROADCAST_SERVER(m_hNetworkServer);

            // ENTER CRITICAL SECTION
            //
            lock (m_hNetworkServerAccessCriticalSection)
            {
                m_nNetworkServerState = 0x00000001;
            }
            //
            // LEAVE CRITICAL SECTION           

            btnStart.Enabled = false;

            btnStop.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            // ENTER CRITICAL SECTION
            //
            lock (m_hNetworkServerAccessCriticalSection)
            {
                m_nNetworkServerState = 0x00000000;
            }
            //
            // LEAVE CRITICAL SECTION

            if (m_hNetworkServer != 0)
            {
                EXPORTS.QCAP_STOP_BROADCAST_SERVER(m_hNetworkServer);

                EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hNetworkServer);

                m_hNetworkServer = 0;
            }

            btnStart.Enabled = true;

            btnStop.Enabled = false;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            m_statFormat.Text = m_psz;
        }
    }
}
